% Vypracoval: Roman Slab 2010   SlabyRoman@seznam.cz 
function varargout = QPSK(varargin)

gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @QPSK_OpeningFcn, ...
                   'gui_OutputFcn',  @QPSK_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before QPSK is made visible.
function QPSK_OpeningFcn(hObject, eventdata, handles, varargin)
    clc;
    set(handles.radiobutton5,'Value',1);
    set(handles.text_krok,'Visible','off');
    set(handles.panel_axes_signal,'Visible','off');
    set(handles.panel_axes1,'Visible','off');
    set(handles.uitoolbar1,'Visible','off');
    pozice(1) = 100;
    pozice(2) = 40;
    pozice(3) = 630;
    pozice(4) = 710;
    set(handles.okno,'Position',pozice);
    
    %%%%% Nastaven potench hodnot popup menu %%%%%%%
    set(handles.popupmenu1,'Value',2);  
    set(handles.popupmenu2,'Value',5);  
    set(handles.popupmenu3,'Value',8);  
    set(handles.popupmenu4,'Value',10);  

    handles.output = hObject;

    guidata(hObject, handles);

% UIWAIT makes QPSK wait for user response (see UIRESUME)
% uiwait(handles.okno);


% --- Outputs from this function are returned to the command line.
function varargout = QPSK_OutputFcn(hObject, eventdata, handles) 

    
    
varargout{1} = handles.output;
 

%%%%%%%%%%%%%%%%%% FUNKCE AXESU %%%%%%%%%%%%%%%%%%%%%%%%
function logo_CreateFcn(hObject, eventdata, handles)
axes(hObject);
imshow('logo.jpg');

%%%%%%%%%%%%%%%%%%%% FUNKCE PANELU %%%%%%%%%%%%%%%%%%%%%%%%%
function panel_axes_signal_CreateFcn(hObject, eventdata, handles)
function panel_axes1_CreateFcn(hObject, eventdata, handles)


%%%%%%%%%%% Kontrola sprvnosti vstupnch editbox (vstupn signl)%%%%%%%%
function edit_input(hObject,handles)
rb=get(handles.radiobutton4,'Value'); % hodnota radio button binarni

input = get(hObject,'String');
if rb== 1   % zadavani bin cisla 
    if (isempty(input))
        set(hObject,'String','00')
        input = get(hObject,'String');
    end
    for n=1:2
        try
            cislo=input(n:n);
            cislo=str2num(cislo);
            if cislo<0 || cislo>1 
                errordlg('Byla zadna patn sekvence','Error');
                set(hObject,'String','00');
                return
            end
        catch % kdy je zadan v editboxu nap 1 slice, tak se provede CATCH
            errordlg('Byla zadna patn sekvence','Error');
            set(hObject,'String','00');
            return
        end
    end
    try
        cislo=input(3);
        cislo=str2num(cislo);
        warndlg('Zadan sekvence byla pli dlouh. Program velikost automaticky upravil','Varovn');     
        for n=1:2
            cislo=input(n:n);
            bin(n)=cislo;  
        end
            set(hObject,'String',bin);
            return        
    catch        
        return
    end

    else %zadavani dec cisla
        input = str2num(get(hObject,'String'));
        if (isempty(input))
            set(hObject,'String','0')
            input = get(hObject,'String');
        end
        if input<0 || input > 3
            errordlg('slo mus bt v intervalu (0,3)','Error');
            set(hObject,'String','0');
        end
    end


function text (i,handles) 
    switch i          
        case 1
            set(handles.text1,'ForegroundColor','r'); 
            set(handles.text2,'ForegroundColor','k'); 
            set(handles.text3,'ForegroundColor','k'); 
            set(handles.text4,'ForegroundColor','k'); 
        case 2
            set(handles.text1,'ForegroundColor','k'); 
            set(handles.text2,'ForegroundColor','r'); 
            set(handles.text3,'ForegroundColor','k'); 
            set(handles.text4,'ForegroundColor','k'); 
        case 3
            set(handles.text1,'ForegroundColor','k'); 
            set(handles.text2,'ForegroundColor','k'); 
            set(handles.text3,'ForegroundColor','r'); 
            set(handles.text4,'ForegroundColor','k'); 
        case 4
            set(handles.text1,'ForegroundColor','k'); 
            set(handles.text2,'ForegroundColor','k'); 
            set(handles.text3,'ForegroundColor','k'); 
            set(handles.text4,'ForegroundColor','r'); 
            
    end

function krokovani(i,handles)
hodnota=get(handles.radiobutton5,'Value');

if hodnota==1
    pause(1)
else
    try
        w = waitforbuttonpress;
        while w==1 % kdy se stidkne klvesa, tak to ek na stisk myi
            w = waitforbuttonpress;
        end 
    catch
        return
    end
end

% 
% ----------- Modulan signl -----------
% 	1. Binrn  modulan signl
% 	2. Decimln modulan signl
% --------- Modulace QPSK v asov oblasti------
% 	1. Psmov signl 
% 	2. Amplitudov modulan sloka 
% 	3. Fzov modulan sloka
% 	4. Konstelace 
% ----- Modulace QPSK ve frekvenn oblasti---
% 	1. Amplitudov frekvenn spektrum
% 	2. Fzov frekvenn spektrum
% 	3. Vkonov frekvenn spektrum


function graf_1(pop,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,tcas)
switch pop
       
     case 2
            axes(handles.axes2);
            plot(t1,w2,'LineWidth',3) 
            xlabel('t[s]')          % Popis x-ove osy
            ylabel('m(t)')          % Popis y-ove osy
            title('Binrn modulacn digitln signl m(t)');
            hold on
            xlim([0 4*(1/f_m)])
            ylim([-1 max(w2)+1])             
            hold off 
     case 3
            axes(handles.axes2);
            plot(t1,w1,'LineWidth',3) 
            xlabel('t[s]')          % Popis x-ove osy
            ylabel('m(t)')          % Popis y-ove osy
            title('Decimln modulacn digitln signl m(t)');
            hold on
            xlim([0 4*(1/f_m)])
            ylim([-1 max(w1)+1])             
            hold off       
     case 5
            axes(handles.axes2);
            plot(t1,vt,'LineWidth',3)   % vykresleni psmovho signlu v(t)
            xlabel('t[s]')           % Popis x-ove osy
            ylabel('v(t)')              % Popis y-ove osy
            title('Psmov signl v(t)');      
            xlim([0 4*(1/f_m)])
            hold on

     case 6
            axes(handles.axes2);
            plot(t1,Rt,'LineWidth',3)            
            xlabel('t[s]')          % Popis x-ove osy
            ylabel('R(t)')          % Popis y-ove osy
            title('Amplitudov modulacn slozka R(t)')    % Popis grafu
            xlim([0 4*(1/f_m)])
            hold on
     case 7
            axes(handles.axes2);
            plot(t1,FI_t,'LineWidth',3) % vykresleni fzov modulace FI(t)
            xlabel('t[s]')          % Popis x-ove osy
            ylabel('\Theta(t)')        % Popis y-ove osy
            title('Fzov modulacn slozka \Theta(t)')  
            xlim([0 4*(1/f_m)])
            hold on   
     case 8 %%% konstelace
            axes(handles.axes2);
            if tcas==1
                fce_konstelace(17)
                dec=decimal(tcas);
                fce_konstelace1(dec)  
                pause(0.5);
                fce_konstelace(dec) 
            else     
                dec=decimal(tcas)
                fce_konstelace1(dec);
                pause(0.5);
                dec=decimal(tcas);
                fce_konstelace(dec)   
            end 
     case 10
            axes(handles.axes2);
            stem(f,V_amp,'LineWidth',3)
            xlabel('f[Hz]')
            ylabel('^F^R|V_\omega|')
            grid on;
            title('Amplitudov frekvencni spektrum pasmoveho (modulovaneho)signalu v(t)')
     case 11
            axes(handles.axes2);
            stem(f,V_faze,'LineWidth',3)
            xlabel('f[Hz]')
            ylabel('\Phi_\omega')
            grid on
            title('Fazove frekvencni spektrum pasmoveho (modulovaneho)signalu v(t)')
     case 12
            axes(handles.axes2);
            stem(f,V_vykon,'LineWidth',3)
            xlabel('f[Hz]')
            ylabel('^F^R|P_m|') 
            grid on
            title('Vykonove frekvencni spektrum pasmoveho (modulovaneho)signalu v(t)')                        
end     

function graf_2(pop,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,tcas)
switch pop
       
     case 2
            axes(handles.axes3);
            plot(t1,w2,'LineWidth',3) 
            xlabel('t[s]')          % Popis x-ove osy
            ylabel('m(t)')          % Popis y-ove osy
            title('Binrn modulacn digitln signl m(t)');
            hold on
            xlim([0 4*(1/f_m)])
            ylim([-1 max(w2)+1])             
            hold off 
     case 3
            axes(handles.axes3);
            plot(t1,w1,'LineWidth',3) 
            xlabel('t[s]')          % Popis x-ove osy
            ylabel('m(t)')          % Popis y-ove osy
            title('Decimln modulacn digitln signl m(t)');
            hold on
            xlim([0 4*(1/f_m)])
            ylim([-1 max(w1)+1])             
            hold off       
     case 5
            axes(handles.axes3);
            plot(t1,vt,'LineWidth',3)   % vykresleni psmovho signlu v(t)
            xlabel('t[s]')           % Popis x-ove osy
            ylabel('v(t)')              % Popis y-ove osy
            title('Psmov signl v(t)');      
            xlim([0 4*(1/f_m)])
            hold on

     case 6
            axes(handles.axes3);
            plot(t1,Rt,'LineWidth',3)            
            xlabel('t[s]')          % Popis x-ove osy
            ylabel('R(t)')          % Popis y-ove osy
            title('Amplitudov modulacn slozka R(t)')    % Popis grafu
            xlim([0 4*(1/f_m)])
            hold on
     case 7
            axes(handles.axes3);
            plot(t1,FI_t,'LineWidth',3) % vykresleni fzov modulace FI(t)
            xlabel('t[s]')          % Popis x-ove osy
            ylabel('\Theta(t)')        % Popis y-ove osy
            title('Fzov modulacn slozka \Theta(t))')  
            xlim([0 4*(1/f_m)])
            hold on   
     case 8 %%% konstelace
            axes(handles.axes3);
            if tcas==1
                fce_konstelace(17)
                dec=decimal(tcas);
                fce_konstelace1(dec)  
                pause(0.5);
                fce_konstelace(dec) 
            else     
                dec=decimal(tcas)
                fce_konstelace1(dec);
                pause(0.5);
                dec=decimal(tcas);
                fce_konstelace(dec)   
            end 
     case 10
            axes(handles.axes3);
            stem(f,V_amp,'LineWidth',3)
            xlabel('f[Hz]')
            ylabel('^F^R|V_\omega|')
            grid on;
            title('Amplitudov frekvencni spektrum pasmoveho (modulovaneho)signalu v(t)')
     case 11
            axes(handles.axes3);
            stem(f,V_faze,'LineWidth',3)
            xlabel('f[Hz]')
            ylabel('\Phi_\omega')
            grid on
            title('Fazove frekvencni spektrum pasmoveho (modulovaneho)signalu v(t)')
     case 12
            axes(handles.axes3);
            stem(f,V_vykon,'LineWidth',3)
            xlabel('f[Hz]')
            ylabel('^F^R|P_m|') 
            grid on
            title('Vykonove frekvencni spektrum pasmoveho (modulovaneho)signalu v(t)')                        
end     

function graf_3(pop,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,tcas)
switch pop
       
     case 2
            axes(handles.axes4);
            plot(t1,w2,'LineWidth',3) 
            xlabel('t[s]')          % Popis x-ove osy
            ylabel('m(t)')          % Popis y-ove osy
            title('Binrn modulacn digitln signl m(t)');
            hold on
            xlim([0 4*(1/f_m)])
            ylim([-1 max(w2)+1])             
            hold off 
     case 3
            axes(handles.axes4);
            plot(t1,w1,'LineWidth',3) 
            xlabel('t[s]')          % Popis x-ove osy
            ylabel('m(t)')          % Popis y-ove osy
            title('Decimln modulacn digitln signl m(t)');
            hold on
            xlim([0 4*(1/f_m)])
            ylim([-1 max(w1)+1])             
            hold off       
     case 5
            axes(handles.axes4);
            plot(t1,vt,'LineWidth',3)   % vykresleni psmovho signlu v(t)
            xlabel('t[s]')           % Popis x-ove osy
            ylabel('v(t)')              % Popis y-ove osy
            title('Psmov signl v(t)');      
            xlim([0 4*(1/f_m)])
            hold on

     case 6
            axes(handles.axes4);
            plot(t1,Rt,'LineWidth',3)            
            xlabel('t[s]')          % Popis x-ove osy
            ylabel('R(t)')          % Popis y-ove osy
            title('Amplitudov modulacn slozka R(t)')    % Popis grafu
            xlim([0 4*(1/f_m)])
            hold on
     case 7
            axes(handles.axes4);
            plot(t1,FI_t,'LineWidth',3) % vykresleni fzov modulace FI(t)
            xlabel('t[s]')          % Popis x-ove osy
            ylabel('\Theta(t)')        % Popis y-ove osy
            title('Fzov modulacn slozka \Theta(t)')  
            xlim([0 4*(1/f_m)])
            hold on   
     case 8 %%% konstelace
            axes(handles.axes4);
            if tcas==1
                fce_konstelace(17)
                dec=decimal(tcas);
                fce_konstelace1(dec)  
                pause(0.5);
                fce_konstelace(dec) 
            else     
                dec=decimal(tcas)
                fce_konstelace1(dec);
                pause(0.5);
                dec=decimal(tcas);
                fce_konstelace(dec)   
            end 
     case 10
            axes(handles.axes4);
            stem(f,V_amp,'LineWidth',3)
            xlabel('f[Hz]')
            ylabel('^F^R|V_\omega|')
            grid on;
            title('Amplitudov frekvencni spektrum pasmoveho (modulovaneho)signalu v(t)')
     case 11
            axes(handles.axes4);
            stem(f,V_faze,'LineWidth',3)
            xlabel('f[Hz]')
            ylabel('\Phi_\omega')
            grid on
            title('Fazove frekvencni spektrum pasmoveho (modulovaneho)signalu v(t)')
     case 12
            axes(handles.axes4);
            stem(f,V_vykon,'LineWidth',3)
            xlabel('f[Hz]')
            ylabel('^F^R|P_m|') 
            grid on
            title('Vykonove frekvencni spektrum pasmoveho (modulovaneho)signalu v(t)')                        
end     

function graf_4(pop,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,tcas)
switch pop
       
     case 2
            axes(handles.axes5);
            plot(t1,w2,'LineWidth',3) 
            xlabel('t[s]')          % Popis x-ove osy
            ylabel('m(t)')          % Popis y-ove osy
            title('Binrn modulacn digitln signl m(t)');
            hold on
            xlim([0 4*(1/f_m)])
            ylim([-1 max(w2)+1])             
            hold off 
     case 3
            axes(handles.axes5);
            plot(t1,w1,'LineWidth',3) 
            xlabel('t[s]')          % Popis x-ove osy
            ylabel('m(t)')          % Popis y-ove osy
            title('Decimln modulacn digitln signl m(t)');
            hold on
            xlim([0 4*(1/f_m)])
            ylim([-1 max(w1)+1])             
            hold off       
     case 5
            axes(handles.axes5);
            plot(t1,vt,'LineWidth',3)   % vykresleni psmovho signlu v(t)
            xlabel('t[s]')           % Popis x-ove osy
            ylabel('v(t)')              % Popis y-ove osy
            title('Psmov signl v(t)');      
            xlim([0 4*(1/f_m)])
            hold on

     case 6
            axes(handles.axes5);
            plot(t1,Rt,'LineWidth',3)            
            xlabel('t[s]')          % Popis x-ove osy
            ylabel('R(t)')          % Popis y-ove osy
            title('Amplitudov modulacn slozka R(t)')    % Popis grafu
            xlim([0 4*(1/f_m)])
            hold on
     case 7
            axes(handles.axes5);
            plot(t1,FI_t,'LineWidth',3) % vykresleni fzov modulace FI(t)
            xlabel('t[s]')          % Popis x-ove osy
            ylabel('\Theta(t)')        % Popis y-ove osy
            title('Fzov modulacn slozka \Theta(t)')  
            xlim([0 4*(1/f_m)])
            hold on   
     case 8 %%% konstelace
            axes(handles.axes5);
            if tcas==1
                fce_konstelace(17)
                dec=decimal(tcas);
                fce_konstelace1(dec)  
                pause(0.5);
                fce_konstelace(dec) 
            else     
                dec=decimal(tcas)
                fce_konstelace1(dec);
                pause(0.5);
                dec=decimal(tcas);
                fce_konstelace(dec)   
            end 
     case 10
            axes(handles.axes5);
            stem(f,V_amp,'LineWidth',3)
            xlabel('f[Hz]')
            ylabel('^F^R|V_\omega|')
            grid on;
            title('Amplitudov frekvencni spektrum pasmoveho (modulovaneho)signalu v(t)')
     case 11
            axes(handles.axes5);
            stem(f,V_faze,'LineWidth',3)
            xlabel('f[Hz]')
            ylabel('\Phi_\omega')
            grid on
            title('Fazove frekvencni spektrum pasmoveho (modulovaneho)signalu v(t)')
     case 12
            axes(handles.axes5);
            stem(f,V_vykon,'LineWidth',3)
            xlabel('f[Hz]')
            ylabel('^F^R|P_m|') 
            grid on
            title('Vykonove frekvencni spektrum pasmoveho (modulovaneho)signalu v(t)')                        
end     
% --- Executes on button press in vykreslit.
function vykreslit_Callback(hObject, eventdata, handles)


%%%%%%%%%%%%%%%%%% Vynulovn graf %%%%%%%%%%%%%%%%%%%%%%%    
axes(handles.axes2);
cla reset
axes(handles.axes3);
cla reset
axes(handles.axes4);
cla reset
axes(handles.axes5);
cla reset

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
set(handles.vykreslit,'String','Aktualizovat');  
set(handles.panel_axes_signal,'Visible','on');
set(handles.panel_axes1,'Visible','on');
set(handles.uitoolbar1,'Visible','on');
% set(handles.vykreslit,'enable','off');


rb=get(handles.radiobutton4,'Value');
data1=get(handles.edit1,'String');
data2=get(handles.edit2,'String');
data3=get(handles.edit3,'String');
data4=get(handles.edit4,'String');


pop1=get(handles.popupmenu1,'Value');  
pop2=get(handles.popupmenu3,'Value');  
pop3=get(handles.popupmenu2,'Value');
pop4=get(handles.popupmenu4,'Value'); 

f_c=str2num(get(handles.edit6,'String'));
pocet_slozek=str2num(get(handles.edit7,'String'));
f_m=str2num(get(handles.edit8,'String'));
A=str2num(get(handles.edit5,'String'));

hodnota_zobrazit=get(handles.zobrazit,'Value');
pozice=get(handles.okno,'Position');

rucni=get(handles.radiobutton6,'Value');
if rucni ==1
    set(handles.text_krok,'Visible','on');
else
    set(handles.text_krok,'Visible','off');
end
%%%%%%%%%%%%%%Naten dat z vstupnch editbox %%%%%%%%%%%%%%%%%%%%%%
%%% pozn: vstup je vdy binrn
if rb==0   %kdy je zadvan sla jsou ve tvaru dec
    [data1] = fce_bin_dec(str2num(data1),2);
    [data2] = fce_bin_dec(str2num(data2),2);
    [data3] = fce_bin_dec(str2num(data3),2);
    [data4] = fce_bin_dec(str2num(data4),2);   
else  %kdy je zadvan sla jsou ve tvaru bin
    [data1] = fce_binstr(data1,2);
    [data2] = fce_binstr(data2,2);
    [data3] = fce_binstr(data3,2);
    [data4] = fce_binstr(data4,2);
end
              
[Dec1]=fce_dec_bin(data1,2);
[Dec2]=fce_dec_bin(data2,2);
[Dec3]=fce_dec_bin(data3,2);
[Dec4]=fce_dec_bin(data4,2);
decimal=[Dec1 Dec2 Dec3 Dec4];
maxlimit=max(decimal);
minlimit=min(decimal);



deltat=1/(f_m*pocet_slozek)/10;
[t1a,w1a,t1b,w1b,t1c,w1c,t1d,w1d,tp1,wp1,tp2,wp2,tp3,wp3,m_t,t_c] = fce_vykresleni(Dec1,Dec2,Dec3,Dec4,maxlimit,minlimit,f_m,deltat);
[m_t2] = fce_vykresleni_2bin(data1,data2,data3,data4,f_m,deltat);
[v_t,FIt,R_t] = fce_pasmovy_sig(m_t,f_c,t_c,A);
[V_amp,V_vykon,V_faze,f] = fce_spektra(v_t,f_m,pocet_slozek);


%%%%%%%%%%%% Vykreslen %%%%%%%%%%%%%%%
if hodnota_zobrazit == 0.
    set(handles.text_krok,'Position',[263 44 266 21])
    [sw v1 v2] = fce_pop(pop1,pop2,pop3,pop4);
    if v1==1 && v2==1
        for i=1:4
            text (i,handles)
            [t1,w1,w2,vt,Rt,FI_t] = fce_uprava_sig(m_t,m_t2,v_t,R_t,FIt,t_c,deltat,f_m,i);
            graf_1(pop1,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
            graf_2(pop2,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
            if i<4
                krokovani(i,handles)
            end            
        end
    elseif v1==1 
        for i=1:4
            text (i,handles)
            [t1,w1,w2,vt,Rt,FI_t] = fce_uprava_sig(m_t,m_t2,v_t,R_t,FIt,t_c,deltat,f_m,i);
            graf_1(pop1,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
            if i==1
                graf_2(pop2,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
            end
            if i<4
                krokovani(i,handles)
            end    
        end


    elseif v2==1 
        for i=1:4
            text (i,handles)
            [t1,w1,w2,vt,Rt,FI_t] = fce_uprava_sig(m_t,m_t2,v_t,R_t,FIt,t_c,deltat,f_m,i);
            if i==1
                graf_1(pop1,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
            end
            graf_2(pop2,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
            if i<4
                krokovani(i,handles)
            end    
        end
        
    else
        i=0;
        [t1,w1,w2,vt,Rt,FI_t] = fce_uprava_sig(m_t,m_t2,v_t,R_t,FIt,t_c,deltat,f_m,i);
        graf_1(pop1,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
        graf_2(pop2,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
    end
else %%% 4 grafy
    set(handles.text_krok,'Position',[500 40 266 21])
    [sw v1 v2] = fce_pop(pop1,pop2,pop3,pop4);
    switch sw
        case 0        
            i=0;
            [t1,w1,w2,vt,Rt,FI_t] = fce_uprava_sig(m_t,m_t2,v_t,R_t,FIt,t_c,deltat,f_m,i);
            graf_1(pop1,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
            graf_2(pop2,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
            graf_3(pop3,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
            graf_4(pop4,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
        case 1
            for i=1:4
                text (i,handles)
                [t1,w1,w2,vt,Rt,FI_t] = fce_uprava_sig(m_t,m_t2,v_t,R_t,FIt,t_c,deltat,f_m,i);
                if i==1
                    graf_1(pop1,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
                    graf_2(pop2,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
                    graf_3(pop3,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
                end
                graf_4(pop4,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
                if i<4
                    krokovani(i,handles)
                end    
            end         
        case 2
            for i=1:4
                text (i,handles)
                [t1,w1,w2,vt,Rt,FI_t] = fce_uprava_sig(m_t,m_t2,v_t,R_t,FIt,t_c,deltat,f_m,i);
                if i==1

                    graf_1(pop1,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
                    graf_2(pop2,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)           
                end
                graf_3(pop3,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
                if i<4
                    krokovani(i,handles)
                end    
                if i==1
                    graf_4(pop4,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
                end
            end
        case 3
            for i=1:4
                text (i,handles)
                [t1,w1,w2,vt,Rt,FI_t] = fce_uprava_sig(m_t,m_t2,v_t,R_t,FIt,t_c,deltat,f_m,i);
                if i==1
                    graf_1(pop1,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
                    graf_2(pop2,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)  
                end
                graf_3(pop3,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
                graf_4(pop4,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
                if i<4
                    krokovani(i,handles)
                end    
            end              
        case 4
            for i=1:4
                text (i,handles)
                [t1,w1,w2,vt,Rt,FI_t] = fce_uprava_sig(m_t,m_t2,v_t,R_t,FIt,t_c,deltat,f_m,i);
                if i==1 
                    graf_1(pop1,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
                end
                graf_2(pop2,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
                if i==1
                    graf_3(pop3,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
                    graf_4(pop4,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
                end
                if i<4
                    krokovani(i,handles)
                end  
            end  
        case 5
            for i=1:4
                text (i,handles)
                [t1,w1,w2,vt,Rt,FI_t] = fce_uprava_sig(m_t,m_t2,v_t,R_t,FIt,t_c,deltat,f_m,i);
                if i==1
                    graf_1(pop1,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
                end
                graf_2(pop2,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
                if i==1
                    graf_3(pop3,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
                end
                graf_4(pop4,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
                if i<4
                    krokovani(i,handles)
                end  
            end  
        case 6
            for i=1:4
                text (i,handles)
                [t1,w1,w2,vt,Rt,FI_t] = fce_uprava_sig(m_t,m_t2,v_t,R_t,FIt,t_c,deltat,f_m,i);
                if i==1
                    graf_1(pop1,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
                end
                graf_2(pop2,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
                graf_3(pop3,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
                if i==1
                    graf_4(pop4,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
                end
                if i<4
                    krokovani(i,handles)
                end  
            end  
        case 7
            for i=1:4
                text (i,handles)
                [t1,w1,w2,vt,Rt,FI_t] = fce_uprava_sig(m_t,m_t2,v_t,R_t,FIt,t_c,deltat,f_m,i);
                if i==1
                    graf_1(pop1,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
                end
                graf_2(pop2,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
                graf_3(pop3,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
                graf_4(pop4,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
                if i<4
                    krokovani(i,handles)
                end  
            end  
        case 8
           for i=1:4
                text (i,handles)
                [t1,w1,w2,vt,Rt,FI_t] = fce_uprava_sig(m_t,m_t2,v_t,R_t,FIt,t_c,deltat,f_m,i);
                graf_1(pop1,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
                if i==1
                    graf_2(pop2,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
                    graf_3(pop3,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
                    graf_4(pop4,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
                end
                if i<4
                    krokovani(i,handles)
                end  
            end   
        case 9
            for i=1:4
                text (i,handles)
                [t1,w1,w2,vt,Rt,FI_t] = fce_uprava_sig(m_t,m_t2,v_t,R_t,FIt,t_c,deltat,f_m,i);
                graf_1(pop1,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
                if i==1
                    graf_2(pop2,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
                    graf_3(pop3,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
                end
                graf_4(pop4,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)  
                if i<4
                    krokovani(i,handles)
                end  
            end  
        case 10
            for i=1:4
                text (i,handles)
                [t1,w1,w2,vt,Rt,FI_t] = fce_uprava_sig(m_t,m_t2,v_t,R_t,FIt,t_c,deltat,f_m,i);
                graf_1(pop1,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
                if i==1
                    graf_2(pop2,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)  
                end
                graf_3(pop3,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
                if i==1
                    graf_4(pop4,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)  
                end
                if i<4
                    krokovani(i,handles)
                end  
            end   
        case 11
            for i=1:4
                text (i,handles)
                [t1,w1,w2,vt,Rt,FI_t] = fce_uprava_sig(m_t,m_t2,v_t,R_t,FIt,t_c,deltat,f_m,i);
                graf_1(pop1,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
                if i==1
                graf_2(pop2,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)  
                end
                graf_3(pop3,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
                graf_4(pop4,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)  
                if i<4
                    krokovani(i,handles)
                end  
            end   
        case 12
            for i=1:4
                text (i,handles)
                [t1,w1,w2,vt,Rt,FI_t] = fce_uprava_sig(m_t,m_t2,v_t,R_t,FIt,t_c,deltat,f_m,i);
                graf_1(pop1,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
                graf_2(pop2,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)  
                if i==1
                    graf_3(pop3,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
                    graf_4(pop4,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
                end
                if i<4
                    krokovani(i,handles)
                end  
            end   
        case 13
            for i=1:4
                text (i,handles)
                [t1,w1,w2,vt,Rt,FI_t] = fce_uprava_sig(m_t,m_t2,v_t,R_t,FIt,t_c,deltat,f_m,i);
                graf_1(pop1,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
                graf_2(pop2,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)   
                if i==1
                    graf_3(pop3,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
                end
                graf_4(pop4,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
                if i<4
                    krokovani(i,handles)
                end  
            end    
        case 14
            for i=1:4
                text (i,handles)
                [t1,w1,w2,vt,Rt,FI_t] = fce_uprava_sig(m_t,m_t2,v_t,R_t,FIt,t_c,deltat,f_m,i);
                graf_1(pop1,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
                graf_2(pop2,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
                graf_3(pop3,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
                if i==1                    
                    graf_4(pop4,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
                end
                if i<4
                    krokovani(i,handles)
                end  
            end    
            
        case 15                  
            for i=1:4
                text (i,handles)
                [t1,w1,w2,vt,Rt,FI_t] = fce_uprava_sig(m_t,m_t2,v_t,R_t,FIt,t_c,deltat,f_m,i);
                graf_1(pop1,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
                graf_2(pop2,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
                graf_3(pop3,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
                graf_4(pop4,V_amp,V_vykon,V_faze,f,f_m,Rt,FI_t,t1,w1,w2,vt,decimal,handles,i)
                if i<4
                    krokovani(i,handles)
                end  
            end        
    end
end

set(handles.text_krok,'Visible','off');
set(handles.text1,'ForegroundColor','k'); 
set(handles.text2,'ForegroundColor','k'); 
set(handles.text3,'ForegroundColor','k'); 
set(handles.text4,'ForegroundColor','k'); 
set(handles.vykreslit,'enable','on');

%%%%%%%%%%%%%%%%%%%  NASTAVEN EDITBOX %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function edit1_Callback(hObject, eventdata, handles)
edit_input(hObject,handles)

function edit2_Callback(hObject, eventdata, handles)
edit_input(hObject,handles)

function edit3_Callback(hObject, eventdata, handles)
edit_input(hObject,handles)

function edit4_Callback(hObject, eventdata, handles)
edit_input(hObject,handles)

function edit5_Callback(hObject, eventdata, handles)
input = str2num(get(hObject,'String'));
if (isempty(input))
    set(hObject,'String','1')
end
if  input<=0
    set(hObject,'String','1')
    errordlg('slo mus bt vt ne 0','Error');
end

function edit6_Callback(hObject, eventdata, handles)
input = str2num(get(hObject,'String'));
if (isempty(input))
    set(hObject,'String','2400')
end
if  input<=0
    set(hObject,'String','2400')
    errordlg('slo mus bt vt ne 0','Error');
end

function edit7_Callback(hObject, eventdata, handles)
input = str2num(get(hObject,'String'));
if (isempty(input))
    set(hObject,'String','150')
end
if  input<=0
    set(hObject,'String','150')
    errordlg('slo mus bt vt ne 0','Error');
end

function edit8_Callback(hObject, eventdata, handles)
input = str2num(get(hObject,'String'));
if (isempty(input))
    set(hObject,'String','50')
end
if  input<=0
    set(hObject,'String','50')
    errordlg('slo mus bt vt ne 0','Error');
end



%%%%%%%%%%%%%%%%% NASTAVEN VZHLEDU EDITBOX %%%%%%%%%%%%%%%%%%%%%%%%%%%%
function edit1_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit2_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit3_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit4_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit5_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit6_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit7_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function edit8_CreateFcn(hObject, eventdata, handles)

if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in checkbox2.
function checkbox2_Callback(hObject, eventdata, handles)
% hObject    handle to checkbox2 (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Hint: get(hObject,'Value') returns toggle state of checkbox2


% --- Executes on button press in zobrazit.
function zobrazit_Callback(hObject, eventdata, handles)
  hodnota = get(hObject,'Value');
    if hodnota == 0
        pozice(1) = 100;
        pozice(2) = 40;
        pozice(3) = 630;
        pozice(4) = 710;
        set(handles.okno,'Position',pozice);
    else
        pozice(1) = 100;
        pozice(2) = 40;
        pozice(3) = 1070;
        pozice(4) = 710;
        set(handles.okno,'Position',pozice);
    end


%%%%%%%%%%%%%%%%%%% NASTAVEN POPUP MENU %%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function popupmenu1_Callback(hObject, eventdata, handles)
hodnota = get(hObject,'Value');
switch hodnota
    case 1
        warndlg('Vyberte prosm jeden z monch modulanch signl')
        set(handles.popupmenu1,'Value',2);  
    case 4
        warndlg('Vyberte prosm jednu z modulac')
        set(handles.popupmenu1,'Value',5); 
    case 9
        warndlg('Vyberte prosm z monch frekvennch spekter')
        set(handles.popupmenu1,'Value',11); 
end


function popupmenu2_Callback(hObject, eventdata, handles)
hodnota = get(hObject,'Value');
switch hodnota
    case 1
        warndlg('Vyberte prosm jeden z monch modulanch signl')
        set(handles.popupmenu1,'Value',2);  
    case 4
        warndlg('Vyberte prosm jednu z modulac')
        set(handles.popupmenu1,'Value',5); 
    case 9
        warndlg('Vyberte prosm z monch frekvennch spekter')
        set(handles.popupmenu1,'Value',11); 
end

function popupmenu3_Callback(hObject, eventdata, handles)
hodnota = get(hObject,'Value');
switch hodnota
    case 1
        warndlg('Vyberte prosm jeden z monch modulanch signl')
        set(handles.popupmenu1,'Value',2);  
    case 4
        warndlg('Vyberte prosm jednu z modulac')
        set(handles.popupmenu1,'Value',5); 
    case 9
        warndlg('Vyberte prosm z monch frekvennch spekter')
        set(handles.popupmenu1,'Value',11); 
end

function popupmenu4_Callback(hObject, eventdata, handles)
hodnota = get(hObject,'Value');
switch hodnota
    case 1
        warndlg('Vyberte prosm jeden z monch modulanch signl')
        set(handles.popupmenu1,'Value',2);  
    case 4
        warndlg('Vyberte prosm jednu z modulac')
        set(handles.popupmenu1,'Value',5); 
    case 9
        warndlg('Vyberte prosm z monch frekvennch spekter')
        set(handles.popupmenu1,'Value',11); 
end

%%%%%%%%%%%%%%%%% NASTAVEN VZHLEDU POPUP MENU %%%%%%%%%%%%%%%%%%%%%%%%%%%%
function popupmenu1_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function popupmenu2_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function popupmenu3_CreateFcn(hObject, eventdata, handles)
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end

function popupmenu4_CreateFcn(hObject, eventdata, handles)

if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end


% --- Executes on button press in radiobutton3.
function radiobutton3_Callback(hObject, eventdata, handles)
set(handles.text_rozsah,'String','0-3');
a=get(handles.edit1,'String');
[a] = fce_dec_4binstr(a,2);
set(handles.edit1,'String',a)

b=get(handles.edit2,'String');
[b] = fce_dec_4binstr(b,2);
set(handles.edit2,'String',b)

c=get(handles.edit3,'String');
[c] = fce_dec_4binstr(c,2);
set(handles.edit3,'String',c)

d=get(handles.edit4,'String');
[d] = fce_dec_4binstr(d,2);
set(handles.edit4,'String',d)

% --- Executes on button press in radiobutton4.
function radiobutton4_Callback(hObject, eventdata, handles)
set(handles.text_rozsah,'String','00-11');
a= str2num(get(handles.edit1,'String'));
[a] = fce_bin_decstr(a,2);
set(handles.edit1,'String',a)

b= str2num(get(handles.edit2,'String'));
[b] = fce_bin_decstr(b,2);
set(handles.edit2,'String',b)

c= str2num(get(handles.edit3,'String'));
[c] = fce_bin_decstr(c,2);
set(handles.edit3,'String',c)

d= str2num(get(handles.edit4,'String'));
[d] = fce_bin_decstr(d,2);
set(handles.edit4,'String',d)




% --- Executes on button press in radiobutton5.
function radiobutton5_Callback(hObject, eventdata, handles)
hodnota = get(hObject,'Value');
if hodnota == 1
    set(handles.radiobutton6,'Value',0);
else
    set(handles.radiobutton6,'Value',1);
end

function radiobutton6_Callback(hObject, eventdata, handles)
hodnota = get(hObject,'Value');
if hodnota == 1
    set(handles.radiobutton5,'Value',0);
else
    set(handles.radiobutton5,'Value',1);
end

%%%%%%%%%%%% Funkce textbox %%%%%%%%%%%%%
function text1_CreateFcn(hObject, eventdata, handles)
function text2_CreateFcn(hObject, eventdata, handles)
function text3_CreateFcn(hObject, eventdata, handles)
function text4_CreateFcn(hObject, eventdata, handles)
function text_krok_CreateFcn(hObject, eventdata, handles)
function text_rozsah_CreateFcn(hObject, eventdata, handles)
